
rm(list=ls())
library(dplyr)
library(Synth)

dat = read.csv("RAS.csv", header=TRUE)

dat$country = as.character(dat$country)


#from negative to positive or vice versa
change.countries = c("Algeria", "Bangladesh", "Bhutan", "Burundi", "Cape Verde",
                     "Central African Republic", "Comoros", "Djibouti", "Ethiopia", "Fiji", "Gabon", "Gambia", "Ghana",
                     "Guinea", "Guinea Bissau", "Guyana", "Ivory Coast", "Kenya", "Lesotho", "Madagascar",
                     "Malawi", "Mali", "Mauritania", "Mozambique", "Nepal", "Niger", "Nigeria", "Pakistan",
                     "Peru", "Senegal", "Sierra Leone", "Thailand", "Tunisia", "Zambia", "Zimbabwe")

#from zero to positive or zero to negative; no crossing the line
# "Benin", "Burkina Faso", "Liberia", "Libya", "Mexico"


dat = dat[dat$country %in% change.countries, c("country", "year", "polity")]

set.seed(12345)


##############################################################
# Create not.in function to make life easier
##############################################################
`%not.in%` <- function(x,y)!('%in%'(x,y))


# global parameters for graphic
width = 3200
height = 2400
res = 300



draw <- function(dv, cty.name, ylim, ylab) {
  
  y = dv
  
  plot(dat[dat$country == cty.name,"year"],  dat[dat$country == cty.name, y], type="l",
       ylim=ylim, ylab=ylab, xlab="Year", axes=FALSE, cex.lab=1.5, lwd=2, main=cty.name)
  axis(side=1, at=seq(1990,2014, by=2))
  axis(side=2, at=seq(min(ylim),max(ylim), by=2))
  
  abline(h=0)
}

png(filename = "Figure A6.1. Polity IV Scores of the Regime Change Countries.png", width=3000, height=4000, res=300)
par(mfrow=c(7,5))

for (cty in change.countries) {
  draw(dv="polity", cty.name=cty, ylim=c(-10, 10), ylab="Polity IV")
}
dev.off()
